<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{$data['title']}}</title>
    <meta name="keywords" content="{{$data['keywords']}}">
    <meta name="description" content="{{$data['description']}}">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="static_index/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link rel="stylesheet" type="text/css" media="screen and (min-width: 767px)" href="static_index/style.css">
    <link rel="stylesheet" type="text/css" media="screen and (max-width: 767px)" href="static_index/small.css">

    <!--[if lt IE 9]>
    <script src="./html5.js" type="text/javascript"></script>
    <script src="./respond.min.js"></script>
    <![endif]-->
</head>
<body style="">
<div class="header-bg"></div>
<div class="header">
    <div class="container">
        <div class="header-box">
            <img src="static_index/logo.png" title="移动机器人与智能技术实验室">
        </div>
    </div>
</div>

<div class="nav-box">
    <div class="container">
        <button type="button" class="navbar-toggle dropdown" data-toggle="collapse"
                data-target="#example-navbar-collapse">
            <span class="sr-only">切换导航</span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
        </button>
        <div class="collapse navbar-collapse nav-div" id="example-navbar-collapse">

            <ul class="nav nav-pills nav-justified ">

                <li class="nav-active"><a href="./index.html">首页</a></li>

                <li><a href="./room.html">成员信息</a></li>

                <li><a href="./xiangmu.html">科研项目</a></li>

                <li><a href="./lunwen.html">论文著作</a></li>

                <li><a href="./dongtai.html">最新动态</a></li>

                <li><a href="./lianjie.html">友情链接</a></li>

                <li><a href="./ziyuan.html">资源共享</a></li>

                <li><a href="./huodong.html">活动剪影</a></li>

                <li><a href="./demo.html">Demo展示</a></li>
            </ul>

        </div>
    </div>
</div>

<div class="index-body">
    <div class="container">
        <div class="body-l col-xs-12 col-sm-8 col-md-8 col-lg-8">
            <h2>基本情况</h2>
            <p style="line-height:28px;padding:10px 20px;">实验室依托北京邮电大学。科研聚焦：深度视觉技术；“地图分割 / 路径规划 / 视觉避障 / Semantic SLAM
                等” 导航技术；人机交互、模式识别技术；其它人工智能前沿技术。<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;实验室提倡开放的与更多人工智能企业合作协同创新，坚持长线基础理论研究、面向垂直场景应用研究。产业化专注
                “深度视觉传感器、家用服务机器人（智能清洁 / 管家陪伴 / 绘画教育）、安防监控机器人等” 预研。<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;实验室目前有全职科研岗教师6人、硕士/博士研究生30余人，每年计划招收硕士生约15人、博士生1～3人。
            </p>

            <div style="text-indent:0;padding:0;background:none;"><sup
                        style="color:#f00;font-weight:bold">New!&nbsp;</sup><a href="./dt/1.htm">Two papers have been
                    accepted By ICPR 2018.</a>
            </div>

            <div id="myCarousel" class="carousel slide index-carousel">
                <!-- 轮播（Carousel）指标 -->
                <ol class="carousel-indicators">
                    <li data-target="#myCarousel" data-slide-to="0" class=""></li>
                    <li data-target="#myCarousel" data-slide-to="1" class=""></li>
                    <li data-target="#myCarousel" data-slide-to="2" class=""></li>
                    <li data-target="#myCarousel" data-slide-to="3" class=""></li>
                    <li data-target="#myCarousel" data-slide-to="4" class="active"></li>
                </ol>
                <!-- 轮播（Carousel）项目 -->
                <div class="carousel-inner">
                    <div class="item">
                        <a href="./ps/2.htm">
                            <div style="background:url(./static_index/project-1.png)" class="hidden-xs"></div>
                            <img src="static_index/project-1.png" class="visible-xs">
                            <span class="banner-text">
                           本课题定义了广义的2.1D简约图理论框架，将其细化成遮挡轮廓检测，局部线索提取、深度次序推理三大模块，分别开展研究，取得了具有国际影响力的研究成果。                        </span>
                        </a>
                    </div>
                    <div class="item">
                        <a href="./ps/4.htm">
                            <div style="background:url(./static_index/project-2.jpg)" class="hidden-xs"></div>
                            <img src="static_index/project-2.jpg" class="visible-xs">
                            <span class="banner-text">
                            实验室从2009年起开展视觉跟踪相关科研攻关工作，针对这一课题中的运动目标表观建模、相似性度量两个基础理论课题，提出了一系列具有国际影响力的研究成果。                        </span></a>

                    </div>
                    <div class="item">
                        <a href="./ps/7.htm">
                            <div style="background:url(./static_index/project-3.jpg)" class="hidden-xs"></div>
                            <img src="static_index/project-3.jpg" class="visible-xs">
                            <span class="banner-text">
                           绘画机器人技术是机器视觉、绘画艺术、新型显示与印刷技术和认知心理学等交叉的前沿研究，也是科学与艺术的对立统一。
                        </span></a>
                    </div>

                    <div class="item">
                        <a href="./ps/6.htm">
                            <div style="background:url(./static_index/project-4.jpg) center no-repeat;"
                                 class="hidden-xs"></div>
                            <img src="static_index/project-4.jpg" class="visible-xs">
                            <span class="banner-text">
                           独有专利的VDEP视觉测距模块，采用激光辅助标定的方法，用优化算法处理摄像头获取的环境图像，计算出场景中各障碍物的深度距离，从而为智能机器人的定位和导航提供高精度数据。                        </span></a>
                    </div>
                    <div class="item active">
                        <a href="./ps/5.htm">
                            <div style="background:url(./static_index/project-5.jpg) no-repeat;"
                                 class="hidden-xs"></div>
                            <img src="static_index/project-5.jpg" class="visible-xs">
                            <span class="banner-text">
                           实验室提出应用深度学习技术在家庭环境下实现机器人的语义地图，并在此基础上通过深度增强学习技术使机器人具备极强的自主学习功能和联想功能。</span></a>
                    </div>
                </div>
                <!--左右切换-->
                <a href="./index.html#myCarousel" class="left carousel-left" data-slide="prev">＜</a>
                <a href="./index.html#myCarousel" class="right carousel-right" data-slide="next">＞</a>
            </div>
            <div class="slide-bg"></div>
        </div>
        <div class="body-r col-xs-12 col-sm-4 col-md-4 col-lg-4">
            <h2>实验室组织机构</h2>
            <div class="body-r-org">
                <img src="static_index/index-organization.png">
            </div>
            <h2 style="border-bottom:2px solid #ccc;padding-bottom:15px;">实验室人才培养类别</h2>
            <ul style="margin-top:-5px;">
                <li>
                    <span>科研工作者<a href="./xiangmu.html"> / more»</a></span>
                    <p>
                        • 主要面向博士生，培养方向：机器视觉、人工智能等，通过一系列前沿课题研究和实践，培养科研思维和习惯，要求具备产出国际一流学术成果的能力。<br>
                        • 主要就业去向 → 高校 / 科研院所、人工智能企业、互联网企业AI部门
                    </p>
                    <i></i>
                </li>
                <li>
                    <span>算法工程师<a href="./xiangmu.html"> / more»</a></span>
                    <p>
                        •
                        主要面向硕士生，培养方向：深度视觉、图像处理、模式识别、机器学习等，通过一系列课题研究和实践，培养文献理解和代码调试素养，要求具备改进算法并验证的能力，或具备理解、复现、移植算法的能力。<br>
                        • 主要就业去向 → 人工智能企业、互联网企业AI部门
                    </p>
                    <i></i>
                </li>
                <li>
                    <span>软件工程师<a href="./xiangmu.html"> / more»</a></span>
                    <p>
                        • 主要面向硕士生，培养方向：互联网系统（前端 / 后台 / 移动终端）、嵌入式系统（C/C++、ARM）、仿真系统等，通过一系列工程实践，培养系统思维和动手能力。<br>
                        • 主要就业去向 → 互联网企业
                    </p>
                </li>
            </ul>
        </div>
    </div>
</div>

<div class="index-footer">
    <div class="container">
        <i></i>
        <span>© 2018 北邮移动机器人与智能技术实验室 苏ICP备15058882号-1</span>
        <span>© 2018 Laboratory of Mobile Robot &amp; Intelligent Technology, BUPT</span>
        <span>联系方式：010-61198980　　地址：北京市海淀区西土城路10号，北京邮电大学新科研大楼801、806室&nbsp;&nbsp;&nbsp;&nbsp;<script
                    type="text/javascript">var cnzz_protocol = (("https:" == document.location.protocol) ? " https://" : " http://");
                document.write(unescape("%3Cspan style='display:inline;' id='cnzz_stat_icon_1259972889'%3E%3C/span%3E%3Cscript src='" + cnzz_protocol + "s95.cnzz.com/z_stat.php%3Fid%3D1259972889%26show%3Dpic2' type='text/javascript'%3E%3C/script%3E"));</script><span
                    style="display:inline;" id="cnzz_stat_icon_1259972889"><a
                        href="http://www.cnzz.com/stat/website.php?web_id=1259972889" target="_blank" title="站长统计"><img
                            border="0" hspace="0" vspace="0" src="static_index/pic2.gif"></a></span><script
                    src="static_index/z_stat.php" type="text/javascript"></script><script src="static_index/core.php"
                                                                                          charset="utf-8"
                                                                                          type="text/javascript"></script></span>
    </div>
</div>
<script src="static_index/jquery-2.0.3.min.js"></script>
<script src="static_index/bootstrap.min.js"></script>
<script src="static_index/robot.js"></script>
<script src="/static/js/news.js"></script>
@if($data['open_bd'] == 1)
<script>
    let bd_image = "{{$data['bd_image']}}",
        bd_link = "{{$data['bd_link']}}";
</script>
<script src="/static/plugins/jquery/jquery.js"></script>
<script src="/static/js/bd.js"></script>
@endif
</body>
</html>