<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
    <style>
        * {
            padding: 0;
            margin: 0;
        }

        .news_wrap {
            position: relative;
            height: 500px;
        }

        .news_wrap li {
            position: relative;
            padding-left: 10px;
            list-style-type: none;
            display: block;
            width: 380px;
            height: 40px;
            line-height: 40px;
            border-bottom: 1px solid grey
        }

        .news_wrap li > span {
            display: block;
            width: 300px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            height: 100%;
            line-height: 40px;
        }

        .news_wrap li > i {
            position: absolute;
            width: 80px;
            font-size: .5rem;
            top: 0;
            right: 0;
        }

        .page-btn {
            position: absolute;
            width: 100%;
            height: 70px;
            bottom: 0;
        }

        .page-btn li {
            font-size: .8rem;
            padding: 0 !important;
            margin-left: 2px;
            list-style-type: none;
            display: inline-block;
            width: 15px;
            height: 15px;
            line-height: 15px;
            text-align: center;
            border: 1px solid grey;
            cursor: pointer;
        }

        .clicked {
            background-color: #0c5460;
            color: #fff;
        }
    </style>
</head>
<body>
<div class="news_wrap">
    <ul>
        @foreach($list[0] as $vo)
            <li style="border-bottom: 1px solid #ccc;">
                <span><a style="text-decoration: none;color:#000" href="detail/{{pathinfo($vo,PATHINFO_BASENAME)}}"
                         target="_blank">{{$titles[rtrim(pathinfo($vo,PATHINFO_BASENAME),'.html')]}}</a></span>
                <i>{{Date('Y/m/d',strtotime($times[rtrim(pathinfo($vo,PATHINFO_BASENAME),'.html')]))}}</i>
            </li>
        @endforeach
    </ul>
    <div class="page-btn">
        <ul>
            @foreach($list as $key => $vo)
                <li class="pg-li {{$key ?'':'clicked'}}">{{$key + 1}}</li>
            @endforeach
        </ul>
    </div>
</div>
<script src="/static/plugins/jquery/jquery.js"></script>
<script>
    let list = JSON.parse("{{json_encode($list)}}".replace(/&quot;/g, '"')),
        titles = JSON.parse("{{json_encode($titles)}}".replace(/&quot;/g, '"')),
        times = JSON.parse("{{json_encode($times)}}".replace(/&quot;/g, '"'));
    $('.pg-li').click(function () {
        $(this).addClass('clicked').siblings().removeClass('clicked');
        let p = ($(this).text() - 1) | 0,
            data = list[p];
        $('.news_wrap > ul').html(function () {
            let html = '';
            $(data).each(function (x, y) {
                let id = y.match(/(\d+)\.html/)[1],
                    time = times[id].split(' ')[0].replace('-', '/');
                html += '<li style="border-bottom: 1px solid #ccc;"><span><a style="text-decoration: none;color:#000" href="detail/' + id + '.html" target="_blank">' + titles[id] + '</a></span> <i>' + time + '</i></li>';
            });
            return html;
        });
    });

</script>
</body>
</html>