new (class userFormApp extends AdminBase {
    constructor() {
        super();
        this.id = id;
        this.init();
    }

    init() {
        // 索引图上传
        let _this = this;
        new Vue({
            el: '#user_form_app',
            data: {
                sort_span: {
                    html: '',
                    show: false
                },
                form_data: {
                    username: '',
                    password: '',
                    avatar: '',
                    role_ids: {},
                    status: 0,
                },
                roles: {},
                avatar: {
                    is_upload: false,
                    title: '点击添加',
                    html: '<i class="fa fa-plus"></i>',
                    style: {lineHeight: '6rem'},
                    url: '',
                },
            },
            mounted: function () {
                let _that = this;
                $.getJSON('/role', function (data) {
                    if (!data || data.code !== 0) {
                        return AdminBase.fail((data && data.msg) || '角色列表获取失败')
                    }
                    _that.roles = data.data.list;
                });
                if (_this.id) {
                    $.getJSON(`/user/user/${_this.id}`, (data) => {
                        if (data.code !== 0 || !data.data) {
                            return AdminBase.danger(data.msg || '操作异常', () => {
                                location.href = '/user/user'
                            }, 1000);
                        }
                        let detail = data.data;
                        this.form_data.username = detail.username;
                        this.form_data.password = '';
                        this.form_data.avatar = detail.avatar;
                        if (this.form_data.avatar) {
                            this.avatar.is_upload = true;
                            this.avatar.title = '点击修改';
                            this.avatar.html = `<div class="avatar_wrap"><i class="fa fa-times-circle" title="删除"></i><img src="${this.form_data.avatar}"></div>`;
                            this.avatar.style = {lineHeight: 'normal'};
                        }
                        _this.editor.setData(detail.content);
                    });
                }
            },
            methods: {
                triggerFile: function (event) {
                    let file = document.querySelector('input[name=avatar]');
                    if (!this.avatar.is_upload) {
                        file.click();
                    }
                    if (this.avatar.is_upload && event.target.tagName === 'I') {
                        //todo 选择上次图片bug，删除服务器图片
                        this.form_data.avatar = '';
                        this.avatar.title = '点击添加';
                        this.avatar.html = '<i class="fa fa-plus"></i>';
                        this.avatar.style = {lineHeight: '6rem'};
                        this.avatar.is_upload = false;
                    }
                },
                handleImage: function (event) {
                    let input = event.currentTarget,
                        file = input.files[0],
                        _this = this;
                    new Promise((resolve, reject) => {
                        new Upload(file, resolve, reject);
                    }).then(function (a) {
                        _this.form_data.avatar = a.default;
                        _this.avatar.is_upload = true;
                        _this.avatar.title = '点击修改';
                        _this.avatar.html = `<div class="avatar_wrap"><i class="fa fa-times-circle" title="删除"></i><img src="${a.default}"></div>`;
                        _this.avatar.style = {lineHeight: 'normal'};
                    }).catch(
                        //todo upload failed suggestion
                    );
                },
                dealRoleChange: function (e) {
                    let el = e.currentTarget,
                        val = el.value,
                        is_checked = $(e.currentTarget).prop('checked');
                    if (is_checked) {
                        this.form_data.role_ids[val] = val | 0;
                    } else {
                        this.$delete(this.form_data.role_ids, val);
                    }
                },
                formSub: function () {
                    let type = `${_this.id ? 'PUT' : 'POST'}`,
                        prefix = _this.id ? '修改' : '创建';
                    $.ajax({
                        url: `/user/user${_this.id ? '/' + _this.id : ''}`,
                        type: type,
                        data: this.form_data,
                        headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                        success: (data) => {
                            return data.code === 0 ? AdminBase.success(`${prefix}成功`, () => {
                                location.href = '/user/user'
                            }, 1000) : AdminBase.fail(data.msg || `${prefix}失败`);
                        }
                    });
                }
            },
            computed: {
                allowedRoles: function () {
                    let filtered = {};
                    for (let i in this.roles) {
                        if (this.roles[i]['id'] !== 1 && this.roles[i]['is_locked'] !== 1) {
                            filtered[i] = this.roles[i];
                        }
                    }
                    return filtered;
                }
            }
        });

    }
});