new (class roleFormApp extends AdminBase {
    constructor() {
        super();
        this.id = id;
        this.init();
    }

    init() {
        // 索引图上传
        let _this = this;
        new Vue({
            el: '#role_form_app',
            data: {
                form_data: {
                    name: '',
                    permission_ids: {},
                    status: 0,
                },
                permissions: {}
            },
            mounted: function () {
                let _that = this;
                $.getJSON('/permission', function (data) {
                    if (!data || data.code !== 0) {
                        return AdminBase.fail((data && data.msg) || '权限列表获取失败')
                    }
                    _that.permissions = data.data;
                });
                if (_this.id) {
                    $.getJSON(`/role/${_this.id}`, (data) => {
                        if (data.code !== 0 || !data.data) {
                            return AdminBase.danger(data.msg || '操作异常', () => {
                                location.href = '/user/user'
                            }, 1000);
                        }
                        let detail = data.data;
                        if (detail.permission_ids.length > 0) {
                            detail.permission_ids.map(function (x) {
                                _that.form_data.permission_ids[x] = x;
                            })
                        }
                        this.form_data.name = detail.name;
                        this.form_data.status = detail.is_locked;
                    });
                }
            },
            methods: {
                dealPermissionChange: function (e) {
                    let el = e.currentTarget,
                        val = el.value,
                        is_checked = $(e.currentTarget).prop('checked');
                    if (is_checked) {
                        this.form_data.permission_ids[val] = val | 0;
                    } else {
                        this.$delete(this.form_data.permission_ids, val);
                    }
                },
                formSub: function () {
                    let type = `${_this.id ? 'PUT' : 'POST'}`,
                        prefix = _this.id ? '修改' : '创建';
                    $.ajax({
                        url: `/role${_this.id ? '/' + _this.id : ''}`,
                        type: type,
                        data: this.form_data,
                        headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                        success: (data) => {
                            return data.code === 0 ? AdminBase.success(`${prefix}成功`, () => {
                                location.href = '/user/user'
                            }, 1000) : AdminBase.fail(data.msg || `${prefix}失败`);
                        }
                    });
                }
            }
        });

    }
});