new (class newsFormApp extends AdminBase {
    constructor() {
        super();
        this.id = 1;
        this.init();
    }

    init() {
        let _this = this;
        new Vue({
            el: '#news_form_app',
            data: {
                form_data: {
                    title: '',
                    keywords: '',
                    description: '',
                    open_bd: false,
                    bd_image: '',
                    bd_link: '',
                },
                index_image: {
                    is_upload: false,
                    title: '点击添加',
                    html: '<i class="fa fa-plus"></i>',
                    style: {lineHeight: '6rem'},
                    url: '',
                },
            },
            mounted: function () {
                if (_this.id) {
                    $.getJSON(`/net/net/${_this.id}`, (data) => {
                        if (data.code !== 0 || !data.data) {
                            return AdminBase.danger(data.msg || '操作异常', () => {
                                location.href = '/admin'
                            }, 1000);
                        }
                        let detail = data.data;
                        this.form_data.title = detail.title;
                        this.form_data.keywords = detail.keywords;
                        this.form_data.description = detail.description;
                        this.form_data.open_bd = detail.open_bd === 1;
                        this.form_data.bd_image = detail.bd_image;
                        this.form_data.bd_link = detail.bd_link;
                        if (this.form_data.bd_image) {
                            this.index_image.is_upload = true;
                            this.index_image.title = '点击修改';
                            this.index_image.html = `<div class="index_image_wrap"><i class="fa fa-times-circle" title="删除"></i><img src="${this.form_data.bd_image}"></div>`;
                            this.index_image.style = {lineHeight: 'normal'};
                        }
                    });
                }
            },
            methods: {
                triggerFile: function (event) {
                    let file = document.querySelector('input[name=index_image]');
                    if (!this.index_image.is_upload) {
                        file.click();
                    }
                    if (this.index_image.is_upload && event.target.tagName === 'I') {
                        //todo 选择上次图片bug，删除服务器图片
                        this.form_data.bd_image = '';
                        this.index_image.title = '点击添加';
                        this.index_image.html = '<i class="fa fa-plus"></i>';
                        this.index_image.style = {lineHeight: '6rem'};
                        this.index_image.is_upload = false;
                    }
                },
                handleImage: function (event) {
                    let input = event.currentTarget,
                        file = input.files[0],
                        _this = this;
                    new Promise((resolve, reject) => {
                        new Upload(file, resolve, reject);
                    }).then(function (a) {
                        _this.form_data.bd_image = a.default;
                        _this.index_image.is_upload = true;
                        _this.index_image.title = '点击修改';
                        _this.index_image.html = `<div class="index_image_wrap"><i class="fa fa-times-circle" title="删除"></i><img src="${a.default}"></div>`;
                        _this.index_image.style = {lineHeight: 'normal'};
                    }).catch(
                        //todo upload failed suggestion
                    );
                },
                formSub: function () {
                    $.ajax({
                        url: '/net/net/' + _this.id,
                        type: 'PUT',
                        data: this.form_data,
                        headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                        success: (data) => {
                            return data.code === 0 ? AdminBase.success(`发布成功`, () => {
                                location.href = '/net/net'
                            }, 1000) : AdminBase.fail(data.msg || `发布失败`);
                        }
                    });
                }
            }
        });

    }
});