/**
 * 分类组件
 * Created by PhpStorm.
 * User: glsy
 * Date: 2018/7/5
 * Time: 上午10:20
 */
Vue.component('sort-component', {
    props: ['url', 'editable'],
    template: `<div class="component-sort-wrap">
                <div>
                    <div class="component-sort-group animated bounceInDown" v-for="(unit,key) in units">
                        <ul>
                            <li @click="show(key)" v-show="_editable">新增分类 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-plus-circle"></i></li>
                            <li class="sort_add_li" v-if="unit.is_add" contenteditable="true" @blur="add(key,unit.fid,$event)" v-focus></li>
                            <li v-for="item in unit.items" :title="item.name" @click="expand(item.id,item.level,$event)">
                            {{item.name}}
                            <i class="fa fa-times-circle" @click="del(item.id,item.level,key)" title="删除" v-if="_editable"></i>
                            <i class="fa fa-edit" @click="update(item.id,key,$event)" title="修改" v-if="_editable"></i>
                            <i class="fa fa-check-circle" @click="_select(item.id,item.level)" title="选择" v-if="!_editable"></i>
                            </li>
                        </ul>
                    </div>
                </div>
             </div>`,
    directives: {
        focus: {
            inserted: function (el) {
                el.focus()
            }
        }
    },
    data() {
        return {
            units: {}
        };
    },
    mounted() {
        //选择模式禁止CUD
        this._editable = this.editable === 'true';
        let _this = this;
        $.getJSON(this.url + '/0', (data) => {
            let items = [];
            for (let i in data) {
                items.push({
                    id: data[i].id,
                    level: data[i].level,
                    name: data[i].name
                });
            }
            _this.$set(_this.units, 1, {fid: 0, items: items});
        });
    },
    methods: {
        expand: function (id, level, e) {
            if (e.target.tagName === 'I') {
                return false;
            }
            for (let i in this.units) {
                if (i >= level + 1) {
                    this.$delete(this.units, i);
                }
            }
            let _this = this;
            $.getJSON(this.url + '/' + id, function (data) {
                let items = [];
                for (let i in data) {
                    items.push({
                        id: data[i].id,
                        level: data[i].level,
                        name: data[i].name
                    });
                }
                //选择模式取消新增
                if (items.length === 0 && !_this._editable) {
                    return false;
                }
                _this.$set(_this.units, level + 1, {fid: id, items: items});
            });
        },
        show: function (key) {
            this.$set(this.units[key], 'is_add', true);
        },
        _select: function (id, level) {
            if (!this._editable) {
                this.$parent.afterSelect && this.$parent.afterSelect(id);
                this.$delete(this.units, level + 1);
                return false;
            }
        },
        add: function (key, fid, e) {
            let _this = this,
                target = e.currentTarget,
                name = target.innerText.replace(/^[\s\t\r\n]*(.*?)[\s\t\r\n]*$/, '$1');
            if (!key || !name || fid === 'undefined') {
                this.units[key]['is_add'] = false;
                return false;
            }
            $.ajax({
                url: this.url,
                type: 'post',
                data: {fid: fid, name: name},
                headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                success: function (data) {
                    _this.units[key]['is_add'] = false;
                    if (data.code !== 0) {
                        return AdminBase.fail(data.msg || '添加失败');
                    } else {
                        _this.units[key].items.push({
                            id: data.data.id,
                            level: data.data.level,
                            name: data.data.name
                        });
                    }
                }
            });
        },
        update(id, key, e) {
            //todo update name
        },
        del(id, level, key) {
            let _this = this;
            return AdminBase.warn('确认删除此分类吗?', function () {
                $.ajax({
                    url: _this.url + '/' + id,
                    type: 'delete',
                    headers: {'X-CSRF-TOKEN': AdminBase.csrf_token()},
                    success: function (data) {
                        if (data.code !== 0) {
                            return AdminBase.fail(data.msg || '删除失败');
                        } else {
                            _this.units[key].items.map(function (x, y) {
                                if (x.id === id) {
                                    _this.units[key].items.splice(y, 1);
                                }
                            });
                            _this.$delete(_this.units, level + 1);
                        }
                    }
                })
            })
        }
    }
});