<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNetTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('net', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->text('title');
            $table->text('keywords');
            $table->text('description');
            $table->tinyInteger('open_bd')->default(0);
            $table->text('bd_image')->nullable();
            $table->text('bd_link')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('net');
    }
}
