<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateImagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('images', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string('name', 50);
            $table->string('path', 255);
            $table->string('desc', 255)->nullable();
            $table->tinyInteger('status')->default(1)->comment('状态:0未审核,1已审核,2审核未通过,3文件已删');
            $table->smallInteger('size')->comment('容量:kb');
            $table->integer('creator_id');
            $table->integer('mender_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('images');
    }
}
