<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdministratorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('administrators', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string('username', 20)->unique();
            $table->string('password', 60);
            $table->tinyInteger('status')->default(0);
            $table->text('avatar')->nullable();
            $table->integer('add_user_id')->nullable();
            $table->string('last_login_ip', 30)->nullable();
            $table->dateTime('last_login_time')->nullable();
            $table->tinyInteger('is_protected')->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('administrators');
    }
}
