<?php

namespace App\Resps\Eloquents;

use App\Resps\Interfaces\Administrator as AdministratorInterface;
use App\Models\Administrator as AdministratorModel;
use Illuminate\Support\Facades\Auth;

class Administrator implements AdministratorInterface
{
    public function login(array $loginInfo)
    {
        if (!$userInfo = AdministratorModel::where('username', $loginInfo['username'])->first()) {
            return ['code' => 100];//用户不存在
        }
        if (!password_verify($loginInfo['password'], $userInfo->password)) {
            return ['code' => 101];//密码错误
        }
        if (Auth::attempt($loginInfo)) {
            $updateInfo = [
                'last_login_time' => Date('Y-m-d H:i:s'),
                'last_login_ip' => request()->getClientIp(),
            ];
            AdministratorModel::where('id', $userInfo->id)->update($updateInfo);
            return ['code' => 0];
        }
        return ['code' => 102];
    }

    public function logout()
    {
        Auth::logout();
        return Auth::check();
    }
}