<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
Route::get('/', function () {
    return redirect('index.html');
});
Route::get('/login', function () {
    return Auth::check() ? redirect('/news/news') : view('admin.login');
});
Route::post('/login', 'Admin\AdministratorController@login');
Route::get('/logout', 'Admin\AdministratorController@logout');
Route::group(['middleware' => 'auth'], function ($route) {
    $route->get('/admin', 'Admin\NewsController@index');

    //seo三要素渲染
    $route->get('/render', 'Admin\NetController@render');
    //文档
    $route->get('/news/detail', function (){
        return view('admin.news.news_detail');
    });
    $route->get('/news/publish/{id}','Admin\NewsController@publish');
    $route->get('/news/form/{id?}', 'Admin\NewsController@form');
    $route->resource('/news/news', 'Admin\NewsController');
    $route->resource('/net/net', 'Admin\NetController');
    //base64图片上传
    $route->post('/upload/base64', 'Admin\UploadController@index');
});
