<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class NetController extends Controller
{
    public function __construct()
    {
    }

    public function index()
    {
        return view('admin.net.net');
    }

    public function show($id)
    {
        return ['code' => 0, 'data' => get_select(DB::table('net')->find($id))];
    }

    public function render()
    {
        $data = get_select(DB::table('net')->find(1));
        view()->share(['data' => $data]);
        $fillables = [
            'index.html' => 'web.index',
            'room.html' => 'web.room',
            'demo.html' => 'web.demo',
            'dongtai.html' => 'web.dongtai',
            'huodong.html' => 'web.huodong',
            'lianjie.html' => 'web.lianjie',
            'lunwen.html' => 'web.lunwen',
            'xiangmu.html' => 'web.xiangmu',
            'ziyuan.html' => 'web.ziyuan',
        ];
        foreach ($fillables as $key => $vo) {
            @file_put_contents(public_path($key), view($vo)->render());
        }
        return ['code' => 0];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update($id)
    {
        $fillable = [
            'title',
            'keywords',
            'description',
            'open_bd',
            'bd_image',
            'bd_link',
        ];
        $params = request()->only($fillable);
        $params['open_bd'] = $params['open_bd'] === 'true';
        try {
            DB::table('net')->where('id', $id)->update($params);
            $this->render();
            return ['code' => 0];
        } catch (\Exception $e) {
            return ['code' => -1];
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
